<?php

class theme_overlay_core_renderer extends core_renderer {

      /**
       * Renders a custom menu object (located in outputcomponents.php)
       *
       * The custom menu this method produces makes use of the YUI3 menunav widget
       * and requires very specific html elements and classes.
       *
       * @staticvar int $menucount
       * @param custom_menu $menu
       * @return string
       */
      protected function render_custom_menu(custom_menu $menu) {

        //Adds custom branches before custom menu items

        if (isloggedin()) {

            $branchlabel = get_string('logout');
            $branchurl   = new moodle_url('/login/logout.php');
            $branchtitle = $branchlabel;
            $branchsort  = -1;

            $branch = $menu->add($branchlabel, $branchurl, $branchtitle, $branchsort);

        } else {

            $branchlabel = get_string('login');
            $branchurl   = new moodle_url('/login/index.php');
            $branchtitle = $branchlabel;
            $branchsort  = -1;

            $branch = $menu->add($branchlabel, $branchurl, $branchtitle, $branchsort);
        }


          static $menucount = 0;
          // If the menu has no children return an empty string
          if (!$menu->has_children()) {
              return '';
          }
          // Increment the menu count. This is used for ID's that get worked with
          // in JavaScript as is essential
          $menucount++;
          // Initialise this custom menu (the custom menu object is contained in javascript-static
          $jscode = js_writer::function_call_with_Y('M.core_custom_menu.init', array('custom_menu_'.$menucount));
          $jscode = "(function(){{$jscode}})";
          $this->page->requires->yui_module('node-menunav', $jscode);
          // Build the root nodes as required by YUI
          $content = html_writer::start_tag('div', array('id'=>'custom_menu_'.$menucount, 'class'=>'yui3-menu yui3-menu-horizontal javascript-disabled custom-menu'));
          $content .= html_writer::start_tag('div', array('class'=>'yui3-menu-content'));
          $content .= html_writer::start_tag('ul');
          // Render each child
          foreach ($menu->get_children() as $item) {
              $content .= $this->render_custom_menu_item($item);
          }
          // Close the open tags
          $content .= html_writer::end_tag('ul');
          $content .= html_writer::end_tag('div');
          $content .= html_writer::end_tag('div');
          // Return the custom menu
          return $content;
    }
}